/**
 * $Id: CVCComplexType24bDecoder.java,v 1.3 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCComplexType24dDecoder extends AbstractXercesErrorDecoder {

    @SuppressWarnings("unused")
    private final ErrorDecoderState state;

    private static final String CVC_COMPLEX_TYPE_2_4_D = "cvc-complex-type.2.4.d";

    public CVCComplexType24dDecoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith(CVC_COMPLEX_TYPE_2_4_D);
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        ElementReference resultRef = elementRef;

        DocumentError result = makeDocumentError(ex, resultRef, CVC_COMPLEX_TYPE_2_4_D, null);
        getErrorPostProcessor().scheduleErrorForProcessing(result);

        return result;
    }
}
