/**
 * 
 */
package com.gsl.sax.decoder.xerces.chris;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Doug Clinton
 * 
 */
public class CVCComplexType322Decoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.3.2.2:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String attributeName = extractString(ex.getMessage(), "Attribute '", "'");

        final DocumentError result = makeDocumentError(ex, elementRef, DocumentError.ATTRIBUTE, null);
        result.setAttributeName(attributeName);
        getErrorPostProcessor().scheduleErrorForProcessing(result);

        return result;
    }

}
