package com.gsl.sax.decoder.xerces.erss;

import java.util.regex.Pattern;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * 
 * @author jesse
 */
public class BadEntityReferenceDecoder extends AbstractXercesErrorDecoder {

    private static final Pattern PATTERN_NOT_DELIMITED = Pattern
            .compile("The reference to entity \".+\" must end with the ';' delimiter\\.");

    private static final Pattern PATTERN_NOT_DECLARED = Pattern.compile("The entity \".+\" was referenced, but not declared\\.");

    public boolean canDecode(final SAXParseException ex) {
        return PATTERN_NOT_DELIMITED.matcher(ex.getMessage()).matches() || PATTERN_NOT_DECLARED.matcher(ex.getMessage()).matches();
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        return makeDocumentError(ex, elementRef, DocumentError.FORMAT, null);
    }
}
