/**
 * $Id: CVCBadFormatDecoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCBadFormatDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-maxLength-valid:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        return makeDocumentError(ex, elementRef, DocumentError.LENGTH, null);
    }
}
