/**
 * $Id: CVCComplexType22Decoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * Deals with cvc-complex-type.2.2
 * 
 * We can get these errors in conjunction with other errors so need to examine
 * the previous error which was raised to see which code to generate.
 * 
 * If the previous error had the same element referenc as our fixed-up reference
 * then we want to suppress this error as it is redundant.
 * 
 * If, howeverm the previous error had the same element reference as our
 * incoming reference, and the error code was blank then we need to generate a
 * BLANK code. We can't generate this directly becuse there error message does
 * not contain the error value so we don't know if it was a blank or format
 * issue. Conversely, the previous error, which would have been a
 * cvc-pattern-valid, did not have enough information to fix up the element
 * reference. Between us we can determine the problem.
 * 
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCComplexType22Decoder extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCComplexType22Decoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.2");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();

        String code = DocumentError.UNKNOWN;

        final ElementReference resultRef = fixupElementReference(elementRef, errorText, "Element '", "'");

        final ElementReference mostRecentRef = state.getMostRecentError().getElementReference();
        if (resultRef.equals(mostRecentRef)) {
            code = DocumentError.SUPPRESS;
        } else {
            final String mostRecentCode = state.getMostRecentError().getSubCode();
            if (elementRef.equals(mostRecentRef) && mostRecentCode.equals(DocumentError.BLANK)) {
                code = DocumentError.BLANK;
                state.getMostRecentError().setSubCode(DocumentError.SUPPRESS);
            } else {
                code = DocumentError.FORMAT;
            }
        }

        return makeDocumentError(ex, resultRef, code, null);
    }
}
