/**
 * $Id: CVCComplexType24aDecoder.java,v 1.4 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCComplexType24aDecoder extends AbstractXercesErrorDecoder {

    private final ErrorDecoderState state;

    public CVCComplexType24aDecoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.4.a");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();
        ElementReference resultRef = elementRef;
        String code = DocumentError.UNKNOWN;

        // If a CVC-Comple2.4.b was received just before this, then it is
        // possible that an expected element was not present. If that's the
        // case, we'll stick with that error by suppressing this one.
        final DocumentError mostRecentError = state.getMostRecentError();

        final String message = mostRecentError.getMessage();
        if (message.startsWith("cvc-complex-type.2.4.b") && mostRecentError.getSubCode().equals("mandatory")) {
            code = DocumentError.SUPPRESS;
            state.reset();
            return makeDocumentError(ex, resultRef, code, null);
        }

        // With these errors the reference is the parent of the bad
        // element so we need to do some work to identify the cause and to fix
        // up the element reference to identify the bad element.
        final String expectedListString = errorText.substring(errorText.indexOf('{'), errorText.indexOf('}'));
        final String[] expectedList = expectedListString.split(",");
        if (expectedList.length == 1) {
            // If there was only one item listed in the error text then
            // that item must be mandatory, so report it as a missing element.
            final String expectedElement = expectedList[0].substring(expectedList[0].indexOf("\":") + 2);
            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/"
                    + expectedElement);
            code = DocumentError.MANDATORY;
        } else if (expectedList.length > 1) {
            // However, if there is more than one item in the expected
            // list then we can infer that the element that was present
            // should not have been there, so report it as a bad element.
            final int elementNameStart = errorText.indexOf("element '") + "element '".length();
            final int elementNameEnd = errorText.indexOf("'", elementNameStart);
            final String invalidElementName = errorText.substring(elementNameStart, elementNameEnd);
            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/"
                    + invalidElementName);
            code = DocumentError.INVALID;
        }
        return makeDocumentError(ex, resultRef, code, null);
    }
}
