/**
 * 
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Doug Clinton
 * 
 */
public class CVCComplexType322Decoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.3.2.2:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String attributeName = extractString(ex.getMessage(), "Attribute '", "'");
        ElementReference newRef = fixupElementReference(elementRef, ex.getMessage(), "element '", "'");
        newRef = SimpleElementReference.makeReference(newRef.getNamespaceURL(), newRef.getXPath() + "/@" + attributeName);

        return makeDocumentError(ex, newRef, DocumentError.ATTRIBUTE, null);
    }

}
