/**
 * $Id: CVCDataTypeValidDecoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 28, 2006
 * 
 */
public class CVCDataTypeValidDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-datatype-valid.1.2.1:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();
        final int valueStart = errorText.indexOf('\'') + 1;
        final int valueEnd = errorText.indexOf('\'', valueStart);
        final String value = errorText.substring(valueStart, valueEnd);

        String code = DocumentError.FORMAT;
        if (value.equals("")) {
            if (errorText.length() <= valueEnd + 1 || !errorText.substring(valueEnd + 1, valueEnd + 2).equals("'")) {
                code = DocumentError.BLANK;
            }
            // code = DocumentError.BLANK;
        }
        return makeDocumentError(ex, elementRef, code, null);
    }

}
