/**
 * $Id$
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 28, 2006
 * 
 */
public class CVCEnumerationValidDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-enumeration-valid:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();
        final int valueStart = errorText.indexOf('\'') + 1;
        final int valueEnd = errorText.indexOf('\'', valueStart);
        final String value = errorText.substring(valueStart, valueEnd);

        String code = DocumentError.VALUE;
        if (value.equals("")) {
            // Need to check for the case where the first character in the
            // string is an apostrophe, otherwise we end up thinking the value
            // was blank.
            if (errorText.length() <= valueEnd + 1 || !errorText.substring(valueEnd + 1, valueEnd + 2).equals("'")) {
                code = DocumentError.BLANK;
            }
        }
        return makeDocumentError(ex, elementRef, code, null);
    }
}
