/**
 * $Id: CVCMaxInclusiveDecoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCMaxInclusiveDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-maxInclusive-valid:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        final String errorText = ex.getMessage();

        final int startOfValue = errorText.indexOf("Value '") + 7;
        final int endOfValue = errorText.indexOf('\'', startOfValue);
        final String valueInError = errorText.substring(startOfValue, endOfValue);

        return makeDocumentError(ex, elementRef, DocumentError.MAXVALUE, valueInError);
    }

}
