/**
 * 
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Gary
 * 
 */
public class CVCMinLengthDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-minLength-valid:");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.gsl.xml.core.sax.decoder.xerces.XercesErrorDecoder#decodeError(org.xml.sax.SAXParseException,
     *      com.gsl.xmldoc.ElementReference)
     */
    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {

        final String errorText = ex.getMessage();

        final int startOfValue = errorText.indexOf("Value '") + 7;
        final int endOfValue = errorText.indexOf('\'', startOfValue);

        if (startOfValue == endOfValue) {
            return makeDocumentError(ex, elementRef, DocumentError.BLANK, null);
        } else {
            final String valueInError = errorText.substring(startOfValue, endOfValue);
            return makeDocumentError(ex, elementRef, DocumentError.FORMAT, valueInError);
        }

    }

}
