/**
 * $Id: CVCPatternValidDecoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCPatternValidDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-pattern-valid:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        String code = DocumentError.FORMAT;

        final String errorText = ex.getMessage();
        final int valueStart = errorText.indexOf("Value '") + "Value '".length();
        final int valueEnd = errorText.indexOf("'", valueStart);
        final String value = errorText.substring(valueStart, valueEnd);

        if (value.equals("")) {
            code = DocumentError.BLANK;
        }

        return makeDocumentError(ex, elementRef, code, value);
    }
}
