/**
 * $Id: CVCType313Decoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCType311Decoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-type.3.1.1:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        DocumentError result;

        final String errorText = ex.getMessage();
        final ElementReference newRef = fixupElementReference(elementRef, errorText, "Element '", "'");

        final String code = DocumentError.ATTRIBUTE;

        result = makeDocumentError(ex, newRef, code, "");
        return result;
    }
}
