/**
 * $Id: CVCType313Decoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class CVCType313Decoder extends AbstractXercesErrorDecoder {

    private final ErrorDecoderState state;

    public CVCType313Decoder(final ErrorDecoderState state) {
        this.state = state;
    }

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-type.3.1.3:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        DocumentError result;

        final String errorText = ex.getMessage();
        final ElementReference newRef = fixupElementReference(elementRef, errorText, "element '", "'");

        String code = DocumentError.UNKNOWN;

        final DocumentError mostRecentError = state.getMostRecentError();
        if (mostRecentError.getElementReference().equals(newRef)) {
            code = DocumentError.SUPPRESS;
        } else {
            if (mostRecentError.getElementReference().equals(elementRef)) {
                mostRecentError.setSubCode(DocumentError.SUPPRESS);
            }
            final int valueStart = errorText.indexOf("value '") + 7;
            final int valueEnd = errorText.indexOf('\'', valueStart);
            final String value = errorText.substring(valueStart, valueEnd);

            code = DocumentError.SUPPRESS;
            if (value.equals("")) {
                if (errorText.length() <= valueEnd + 1 || !errorText.substring(valueEnd + 1, valueEnd + 2).equals("'")) {
                    code = DocumentError.BLANK;
                }
            }
        }
        result = makeDocumentError(ex, newRef, code, "");
        return result;
    }
}
