/**
 * $Id: SuppressErrorDecoder.java,v 1.2 2006/08/10 15:19:10 dec Exp $
 */
package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * This decoder will simply produce a DocumentError with a code of "suppress",
 * which signals the later stages of processing that this error should not
 * generate any output.
 * 
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class SuppressErrorDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.4:");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        return makeDocumentError(ex, elementRef, DocumentError.SUPPRESS, null);
    }
}
