package com.gsl.sax.decoder.xerces.erss;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;

/**
 * 
 * @author jesse
 */
public class WellFormedTextOrMarkupDecoder extends AbstractXercesErrorDecoder {

    public boolean canDecode(final SAXParseException ex) {
        return ex.getMessage().equals("The content of elements must consist of well-formed character data or markup.");
    }

    public DocumentError decodeError(final SAXParseException ex, final ElementReference elementRef) {
        return makeDocumentError(ex, elementRef, DocumentError.FORMAT, null);
    }
}
