/*
 * Created on 16-Dec-2005
 *
 * $Id: XMLGrammarPoolTaxYearImpl.java,v 1.1 2006/04/08 11:43:12 dec Exp $
 */
package com.gsl.sax.xerces;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

import com.gsl.logging.LoggerFactory;

/**
 * Creates the grammer pool based on tax year to improve performance. NOTE: you
 * can not use the same grammar pool for both 0405 and 0506 as the namespaces
 * are the same for these years but the schemas are diffrent ! YEP Mad !
 */
class XMLGrammarPoolMapImpl implements XMLGrammarPoolMap {

    private static final Logger logger = LoggerFactory.getLogger(XMLGrammarPoolMapImpl.class.getName());

    private final static Map<Object, XMLGrammarPool> MAP = new HashMap<Object, XMLGrammarPool>();

    public XMLGrammarPool getXMLGrammarPool(final Object key) {
        XMLGrammarPool result = MAP.get(key);
        if (result == null) {
            synchronized (MAP) {
                result = MAP.get(key);
                if (result == null) {
                    result = new XMLGrammarPoolImpl();
                    MAP.put(key, result);
                }
            }
        }
        return result;
    }

    public void flush(final Object key) {
        synchronized (MAP) {
            if (MAP.containsKey(key)) {
                logger.fine("Flushing XMLGrammarPool for key = " + key.toString());
                MAP.put(key, null);
            }
        }
    }
}
