package com.gsl.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Builder of a composite comparator. A composite comparator is simply a chain
 * of primitive comparators.
 * 
 * @author rhys
 */

public class CompositeComparatorBuilder<T> {

    private final List<Comparator<T>> comparators = new LinkedList<Comparator<T>>();

    public void add(final Comparator<T> comparator) {
        comparators.add(comparator);
    }

    public Comparator<T> makeCompositeComparator() {
        return new CompositeComparator<T>(comparators);
    }
}

class CompositeComparator<T> implements Comparator<T> {

    private final List<Comparator<T>> comparators;

    CompositeComparator(final List<Comparator<T>> comparators) {
        this.comparators = comparators;
    }

    public int compare(final T o1, final T o2) {
        int compare = 0;
        final Iterator<Comparator<T>> i = comparators.iterator();

        while ((compare == 0) && i.hasNext()) {
            final Comparator<T> comparator = i.next();
            compare = comparator.compare(o1, o2);
        }

        return compare;
    }
}