package com.gsl.util;

public abstract class OneShotUseSupport {

    private boolean oneShotUsed = false;

    protected void checkOneShotUse() throws OneShotUseException {
        checkOneShotUse(getOneShotUseExceptionMessage());
    }

    protected synchronized void checkOneShotUse(String message) throws OneShotUseException {
        if (oneShotUsed) {
            if (message == null)
                message = "this instance can only be used once: " + getClass().getName();
            throw new OneShotUseException(message);
        }
        oneShotUsed = true;
    }

    protected String getOneShotUseExceptionMessage() {
        return null;
    }
}
