/**
 * 
 */
package com.gsl.util;

/**
 * @author doug
 * 
 */
public class Pair<T1, T2> {
    public final T1 v1;

    public final T2 v2;

    public Pair(final T1 v1, final T2 v2) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException("Pair cannot accept null objects");
        }
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public int hashCode() {
        return v1.hashCode() ^ v2.hashCode();
    }

    @Override
    public boolean equals(final Object other) {
        boolean result = false;

        if (other != null && other.getClass() == this.getClass()) {
            final Pair<?, ?> that = (Pair<?, ?>) other;

            result = v1.equals(that.v1) && v2.equals(that.v2);
        }

        return result;
    }

}
