package com.gsl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class PropertiesLoadableSupport extends LoadableSupport {

    @Override
    public void load(final InputStream is) throws IOException {
        final Properties p = new Properties();
        p.load(is);
        load(p);
    }

    public abstract void load(Properties p);

    //
    // property helper methods
    //

    public static String getString(final Properties p, final String key) {
        return getString(p, key, null);
    }

    public static String getString(final Properties p, final String key, final String def) {
        return p.getProperty(key, def);
    }

    public static long getInteger(final Properties p, final String key) {
        return getInteger(p, key, 0);
    }

    public static long getInteger(final Properties p, final String key, final long def) {
        final String val = p.getProperty(key);
        return (val != null) ? Long.parseLong(val) : def;
    }

    public static double getFloat(final Properties p, final String key) {
        return getFloat(p, key, 0);
    }

    public static double getFloat(final Properties p, final String key, final double def) {
        final String val = p.getProperty(key);
        return (val != null) ? Double.parseDouble(val) : def;
    }

    public static boolean getBoolean(final Properties p, final String key) {
        return getBoolean(p, key, false);
    }

    public static boolean getBoolean(final Properties p, final String key, final boolean def) {
        final String val = p.getProperty(key);
        return (val != null) ? Boolean.valueOf(val).booleanValue() : def;
    }
}
