/**
 * 
 */
package com.gsl.util;

/**
 * Simple utility class to simplify timing of operations.
 * 
 * @author doug
 * 
 */
public class Stopwatch {

    private long startTime = -1;

    private long stopTime = -1;

    public Stopwatch start() {
        startTime = System.currentTimeMillis();
        stopTime = -1;

        return this;
    }

    public long stop() {
        stopTime = System.currentTimeMillis();
        return elapsed();
    }

    public long elapsed() {
        long result = -1;
        if (startTime > -1) {
            if (stopTime > -1) {
                result = stopTime - startTime;
            } else {
                result = System.currentTimeMillis() - startTime;
            }
        }
        return result;
    }
}
