package com.gsl.util.builder;

import java.util.Map;
import java.util.Set;

/**
 * A map builder takes map entries one [key, value] pair at a time and
 * constructs a map, iteratively.
 * 
 * @author rhys
 */

public interface MapBuilder<T1, T2> {

    void add(T1 key, T2 value);

    Map<T1, Set<T2>> getMap();
}
