package com.gsl.util.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * A builder of a one-to-many map (each key maps to potentially many values).
 * Here this is implemented as a regular {@code HashMap}, with each key mapping
 * to a {@code HashSet} of values.
 * 
 * @author rhys
 */

public class ValueHashSetHashMapBuilder<T1, T2> implements MapBuilder<T1, T2> {

    private final Map<T1, Set<T2>> map = new HashMap<T1, Set<T2>>();

    public void add(final T1 key, final T2 value) {
        Set<T2> valuesForKey = map.get(key);
        if (valuesForKey == null) {
            valuesForKey = new HashSet<T2>();
            map.put(key, valuesForKey);
        }

        valuesForKey.add(value);
    }

    public Map<T1, Set<T2>> getMap() {
        return map;
    }
}
