/*
 * Created on Apr 16, 2006
 *
 * $Id: AbstractCache.java,v 1.1 2006/04/16 15:46:54 dec Exp $
 */
package com.gsl.util.cache;

/**
 * @author douglas
 * @since Apr 16, 2006
 */
public abstract class AbstractCache implements Cache {
    private long hitCount = 0;

    private long missCount = 0;

    /**
     * Allows a sublcass to record a cache hit.
     */
    protected final void hit() {
        hitCount++;
    }

    /**
     * Allows a subclass to record a cache miss
     */
    protected final void miss() {
        missCount++;
    }

    public float efficiency() {
        float result = -1.0f;
        if (missCount > 0) {
            result = hitCount / (float) missCount;
        }

        return result;
    }

    public abstract void flush();
}
