package com.gsl.util.classlookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Matching classes are cached so that another lookup within the JVM for the
 * same base cache key will return the cached set. We have assumed that the set
 * of classes available will not change during the lifetime of the JVM.
 * 
 * @author jesse
 */
public class CachingClassCollector implements ClassNameCollector {

    private static final Map<String, Collection<String>> cache = new HashMap<String, Collection<String>>();

    private final ClassNameCollector collector;

    private final String cacheKey;

    public CachingClassCollector(final ClassNameCollector collector) {
        this.collector = collector;
        this.cacheKey = collector.toString();
    }

    public Collection<String> collectClassNames() {
        Collection<String> classes;

        synchronized (cache) {
            classes = cache.get(cacheKey);
            if (classes == null) {
                classes = collectClassesToCache();
                cache.put(cacheKey, classes);
            }
        }
        return classes;
    }

    protected Collection<String> collectClassesToCache() {
        return collector.collectClassNames();
    }
}
