package com.gsl.util.classlookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class CachingClassInstanceCollector extends CachingClassCollector implements ClassCollector {

    private static final Logger logger = Logger.getLogger("util.classlookup");

    public CachingClassInstanceCollector(final ClassNameCollector collector) {
        super(collector);
    }

    public Collection<Class<?>> collectClasses() {
        final Collection<String> classNames = collectClassNames();

        final List<Class<?>> classes = new ArrayList<Class<?>>(classNames.size());
        for (final String className : classNames) {
            try {
                classes.add(Class.forName(className));
            } catch (final ClassNotFoundException e) {
                logger.warning("Could not find class " + className);
            }
        }

        return classes;
    }
}
