/**
 * 
 */
package com.gsl.util.classlookup;

import java.util.Collection;

/**
 * This composite provides a fallback mechanism for loading classes when they
 * cannot be found on the classpath for some reason. If the classpath scan
 * returns no classes then we defer to a properties file lookup.
 * 
 * @author jesse
 * 
 */
public final class CompositeInterfaceCollector implements ClassNameCollector {
    private final PropertiesFileClassCollector propertiesFileCollector;

    private final InterfaceInstanceCollector interfaceInstanceCollector;

    private final String stringName;

    public CompositeInterfaceCollector(final String basePackageName, final Class<?> interfaceToCollect) {
        stringName = "CompositeInterfaceCollector [basePackageName='" + basePackageName + "', interfaceCollector="
                + interfaceToCollect.getName() + "]";

        interfaceInstanceCollector = new InterfaceInstanceCollector(basePackageName, interfaceToCollect);
        propertiesFileCollector = new PropertiesFileClassCollector(basePackageName, interfaceToCollect);
    }

    public Collection<String> collectClassNames() {
        Collection<String> classes = propertiesFileCollector.collectClassNames();
        if (classes.size() == 0) {
            classes = interfaceInstanceCollector.collectClassNames();
        }
        return classes;
    }

    /*
     * must implement this properly to support caching
     */
    @Override
    public String toString() {
        return stringName;
    }
}
