/**
 * $Id: $
 */
package com.gsl.util.classlookup;

/**
 * @author Doug Clinton
 * 
 */
public class PackageClassCollector extends ClassPathClassCollector {
    protected String basePackageName;

    public PackageClassCollector(final String basePackageName) {
        this.basePackageName = basePackageName;
    }

    @Override
    protected boolean isMatchingClass(final String classFileName) {
        boolean result = false;
        if (super.isMatchingClass(classFileName)) {
            final String className = classNameFromFile(classFileName);
            if (className.startsWith(basePackageName)) {
                result = true;
            }
        }
        return result;
    }
}
