package com.gsl.util.classlookup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropertiesFileClassCollector implements ClassNameCollector {

    private final String propertiesFileName;

    public PropertiesFileClassCollector(final String basePackageName) {
        this(basePackageName, null);
    }

    public PropertiesFileClassCollector(final String basePackageName, final Class<?> typeToFind) {
        this.propertiesFileName = createPropertiesPathAndFilename(basePackageName, typeToFind);
    }

    public Collection<String> collectClassNames() {
        final InputStream is = getClass().getResourceAsStream(propertiesFileName);

        final Properties properties = new Properties();
        try {
            if (is != null) {
                properties.load(is);
                is.close();
            }
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }

        final Set<String> classNames = new HashSet<String>();
        final Set<Object> names = properties.keySet();
        for (final Object name : names) {
            classNames.add((String) name);
        }

        return Collections.unmodifiableSet(classNames);
    }

    public static String createPropertiesPathAndFilename(final String basePackageName, final Class<?> typeToFind) {
        String typeName = "";
        if (typeToFind != null) {
            typeName = typeToFind.getSimpleName();
        }
        final String pathName = "/" + basePackageName.replace('.', '/');
        final String filename = pathName + "/" + "Collected" + typeName + ".properties";
        return filename;
    }

}
