package com.gsl.util.classlookup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

import com.gsl.logging.LoggerFactory;

public class PropertiesFileClassCollector2 implements ClassCollector {

    private static final Logger log = LoggerFactory.getLogger("com.gsl.util.classlookup");

    private final String propertiesFileName;

    public PropertiesFileClassCollector2(final String basePackageName) {
        this(basePackageName, null);
    }

    public PropertiesFileClassCollector2(final String basePackageName, final Class<?> typeToFind) {
        this.propertiesFileName = createPropertiesPathAndFilename(basePackageName, typeToFind);
    }

    @SuppressWarnings("unchecked")
    public Collection collectClasses() {
        try {
            final Properties properties = new Properties();

            final Enumeration<URL> resources = getClass().getClassLoader().getResources(propertiesFileName);
            while (resources.hasMoreElements()) {
                final URL url = resources.nextElement();
                final InputStream is = url.openStream();
                properties.load(is);
                is.close();
            }

            if (properties.isEmpty()) {
                log.warning("no classes found for: '" + propertiesFileName + "'");
            }

            return properties.keySet();
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * NOTE: Whereas the path passed to getClass().getResourceAsStream() in
     * PropertiesFileClassCollector may have a leading forward slash, the path
     * passed to getClassLoader().getResources() in this collector class must
     * not.
     */
    private String createPropertiesPathAndFilename(final String basePackageName, final Class<?> typeToFind) {
        String typeName = "";
        if (typeToFind != null)
            typeName = typeToFind.getSimpleName();
        final String pathName = basePackageName.replace('.', '/');
        final String filename = pathName + "/" + "Collected" + typeName + ".properties";
        return filename;
    }
}
