package com.gsl.util.classlookup;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;

public class PropertiesFileGenerator {

    public static void main(final String args[]) {
        try {
            for (int i = 0; i <= args.length - 3; i += 3) {
                final String basePackageName = args[i];
                final Class<?> typeToFind = Class.forName(args[i + 1]);
                String outputFileName = args[i + 2];

                if (outputFileName == null || outputFileName.length() == 0) {
                    outputFileName = PropertiesFileClassCollector.createPropertiesPathAndFilename(basePackageName, typeToFind)
                            .substring(1);
                }

                System.out.println("Writing classes to properties file:");
                System.out.println(" basePackageName=" + basePackageName);
                System.out.println(" typeToFind=" + typeToFind.getName());
                System.out.println(" outputFileName=" + outputFileName);

                final int numClasses = writeClassesToPropertiesFile(basePackageName, typeToFind, outputFileName);

                System.out.println();
                System.out.println("Wrote " + numClasses + " classes.");
                System.out.println();
                System.out.println();
            }
        } catch (final Exception e) {
            e.printStackTrace();
        }
    }

    public static int writeClassesToPropertiesFile(final String basePackageName, final Class<?> typeToFind,
            final String outputFileName) throws IOException {
        final InterfaceInstanceCollector collector = new InterfaceInstanceCollector(basePackageName, typeToFind);
        // use treeset to maintain natural ordering
        final Collection<?> classes = new TreeSet<Object>(collector.collectClassNames());

        final Writer writer = new FileWriter(outputFileName);

        for (final Object name : classes) {
            writer.write((String) name);
            writer.write("=\n");
        }

        writer.close();

        return classes.size();
    }

    public static void writeClassesToPropertiesFile(final String[][] packagesToCollect) {
        for (final String[] element : packagesToCollect) {
            final String className = element[1];
            try {
                final Class<?> typeToFind = Class.forName(className);
                writeClassesToPropertiesFile(element[0], typeToFind, element[2]);
            } catch (final Throwable t) {
                t.printStackTrace();
            }
        }
    }
}
