/*
 * Created on Feb 26, 2006
 *
 * $Id$
 */
package com.gsl.util.collections;

import java.util.HashMap;
import java.util.Map;

/**
 * This is a utility class which implements a map in which values are held
 * against a combination of two keys.
 * 
 * @author douglas
 * @since Feb 26, 2006
 */
public class NestedHashMapTwoKeyMap<K1, K2, V> implements TwoKeyMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> primaryMap = new HashMap<K1, Map<K2, V>>();

    /*
     * (non-Javadoc)
     * 
     * @see com.gsl.util.collections.TwoKeyMap#put(java.lang.Object,
     *      java.lang.Object, java.lang.Object)
     */
    public void put(final K1 key1, final K2 key2, final V value) {
        Map<K2, V> secondaryMap = primaryMap.get(key1);
        if (secondaryMap == null) {
            secondaryMap = new HashMap<K2, V>();
            primaryMap.put(key1, secondaryMap);
        }
        secondaryMap.put(key2, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.gsl.util.collections.TwoKeyMap#get(java.lang.Object,
     *      java.lang.Object)
     */
    public V get(final K1 key1, final K2 key2) {
        V result = null;
        final Map<K2, V> secondaryMap = primaryMap.get(key1);
        if (secondaryMap != null) {
            result = secondaryMap.get(key2);
        }
        return result;
    }

    public boolean containsKeys(final K1 key1, final K2 key2) {
        boolean result = false;
        final Map<K2, V> secondaryMap = primaryMap.get(key1);
        if (secondaryMap != null) {
            result = secondaryMap.containsKey(key2);
        }
        return result;
    }

    @Override
    public String toString() {
        return primaryMap.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.gsl.util.collections.TwoKeyMap#clear()
     */
    public void clear() {
        primaryMap.clear();
    }
}
