package com.gsl.util.properties;

import java.util.Properties;

import com.gsl.util.PropertiesLoadableSupport;

public class MutableParamProperties implements ParamProperties {

    private ParamProperties defaults;

    private Properties props = new Properties();

    public MutableParamProperties() {
        this(NullParamProperties.INSTANCE);
    }

    public MutableParamProperties(final ParamProperties defaults) {
        this.defaults = defaults;
    }

    public void setProperty(final String key, final String value) {
        props.setProperty(key, value);
    }

    public boolean getBoolean(final String propertyName, final boolean defaultValue) {
        if (props.containsKey(propertyName))
            return PropertiesLoadableSupport.getBoolean(props, propertyName);
        return defaults.getBoolean(propertyName, defaultValue);
    }

    public String getString(final String propertyName, final String defaultValue) {
        if (props.containsKey(propertyName))
            return PropertiesLoadableSupport.getString(props, propertyName);
        return defaults.getString(propertyName, defaultValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        final MutableParamProperties clone = (MutableParamProperties) super.clone();
        clone.defaults = new MutableParamProperties(defaults);
        clone.props = new Properties(props);
        return clone;
    }
}
