package com.gsl.util.properties;

public class NullParamProperties implements ParamProperties {

    public static final ParamProperties INSTANCE = new NullParamProperties();

    private NullParamProperties() {
        // enforce singleton
    }

    public boolean getBoolean(final String propertyName, final boolean defaultValue) {
        return defaultValue;
    }

    public String getString(final String propertyName, final String defaultValue) {
        return defaultValue;
    }

    /**
     * {@link NullParamProperties} is a singleton so clone() simply returns the
     * singleton instance
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        return this;
    }
}
