/*
 * Created on Jul 15, 2005
 * 
 * $Id$
 */
package com.gsl.util.properties;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * @author Jaco
 * @since Jul 15, 2005
 */
public class PropertyUtils {

    public static Properties loadProperties(final String filename) {
        final Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            properties.load(fis);
        } catch (final FileNotFoundException e) {
            e.printStackTrace();
        } catch (final IOException e1) {
            e1.printStackTrace();
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (final IOException e) {
                    // ignore
                }
            }
        }

        return properties;
    }
}
