/*
 * Created on Apr 15, 2006
 *
 * $Id: BasicMethodLocator.java,v 1.1 2006/04/16 13:01:21 dec Exp $
 */
package com.gsl.util.reflection;

import java.lang.reflect.Method;

/**
 * Implements a general purpose MethodLocator. The creator must provide the
 * parameter types and return type of the methods to locate and the
 * <em>name</em> parameter of the locateMethod() call is taken as a straight,
 * literal method name.
 * 
 * @author douglas
 * @since Apr 15, 2006
 */
public class BasicMethodLocator implements MethodLocator {

    private final Class<?>[] paramterTypes;

    private final Class<?> returnType;

    public BasicMethodLocator(final Class<?>[] paramterTypes, final Class<?> returnType) {
        this.paramterTypes = new Class[paramterTypes.length];
        for (int i = 0; i < paramterTypes.length; i++) {
            this.paramterTypes[i] = paramterTypes[i];
        }
        this.returnType = returnType;
    }

    public Method locateMethod(final Class<?> clazz, final String methodName) {
        Method result = null;

        try {
            final Method method = clazz.getMethod(methodName, paramterTypes);
            if (method.getReturnType() == returnType) {
                result = method;
            }
        } catch (final SecurityException e) {
            // do nothing - have not found a matching method
        } catch (final NoSuchMethodException e) {
            // do nothing - have not found a matching method
        }

        return result;
    }

}
