/*
 * Created on Apr 15, 2006
 *
 * $Id: MethodLocator.java,v 1.1 2006/04/16 13:01:21 dec Exp $
 */
package com.gsl.util.reflection;

import java.lang.reflect.Method;

/**
 * Describes an object which can locate a method on a class based on a name and
 * whatever parameters the implementation wishes to call for.
 * 
 * @author douglas
 * @since Apr 15, 2006
 */
public interface MethodLocator {
    /**
     * @return a Method corresponding to the name on the given class, or null if
     *         no method was found. An implementation can interpret the name as
     *         it wishes. For example, it might be interpreted as a literal name
     *         of a method, or as a property name for which a getter or setter
     *         is wanted.
     */
    Method locateMethod(Class<?> clazz, String name);
}
