/*
 * Created on Apr 15, 2006
 *
 * $Id: MethodLocatorCacheEntry.java,v 1.2 2006/04/18 14:13:02 dec Exp $
 */
package com.gsl.util.reflection;

import java.lang.reflect.Method;

/**
 * @author douglas
 * @since Apr 15, 2006
 */
public class MethodLocatorCacheEntry {
    /**
     * Use this when the method lookup returned null. Because Method is final we
     * can't subclass it for a null object pattern.
     * 
     * @label NullPlaceholder
     */
    public static final MethodLocatorCacheEntry NullPlaceholder = new MethodLocatorCacheEntry(null);

    private final Method method;

    public MethodLocatorCacheEntry(final Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return method;
    }
}
