package com.gsl.util.version;


/**
 * @author rhys
 */

public class Version implements Comparable<Version> {

    private final int[] elements;

    public Version(final int[] elements) {
        this.elements = elements;
    }

    public int compareTo(final Version o) {
        final Version other = o;

        int compare = 0;
        int i = 0;

        while ((compare == 0) && ((i < this.elements.length) || (i < other.elements.length))) {
            if (i == this.elements.length) {
                compare = -1;
            } else if (i == other.elements.length) {
                compare = 1;
            } else {
                compare = new Integer(this.elements[i]).compareTo(new Integer(other.elements[i]));
                i++;
            }
        }

        return compare;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != getClass()) {
            return false;
        }
        final Version other = (Version) o;
        return (this.compareTo(other) == 0);
    }

    @Override
    public String toString() {
        final String DOT = ".";
        String separator = "";
        final StringBuffer buffer = new StringBuffer();

        for (final int element : elements) {
            buffer.append(separator + element);
            separator = DOT;
        }

        return buffer.toString();
    }
}
