package eric.header;

import java.util.HashMap;
import java.util.Map;

public class ERICEnvelopeEntityResolutionTable {

    private static final String[][] TABLE_1_5 = { { ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE, "/EricEnvelope-v1-5.xsd" } };

    private static final String[][] TABLE_1_4 = { { ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE, "/EricEnvelope-v1-4.xsd" } };

    private static final String[][] TABLE_1_3 = { { ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE, "/EricEnvelope-v1-3.xsd" } };

    private static Map<String, String[][]> tableVersions = new HashMap<String, String[][]>();

    static {
        tableVersions.put(ERICHeaderConstants.VERSION_1_3, TABLE_1_3);
        tableVersions.put(ERICHeaderConstants.VERSION_1_4, TABLE_1_4);
        tableVersions.put(ERICHeaderConstants.VERSION_1_5, TABLE_1_5);
    }

    /**
     * Returns an entity resolution table based on the supplied version, which
     * can be one of the ERICHeaderConstants. If the version is not recognised
     * then this will return the resolution table for envelope version 1.5.
     */
    public static String[][] getEntityResolutionTable(final String version) {
        String[][] table = TABLE_1_5;

        if (tableVersions.containsKey(version)) {
            table = tableVersions.get(version);
        }
        return table;
    }
}
