/**
 * 
 */
package eric.header;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.DocumentErrorFilter;

/**
 * Filter any errors which are within ChRISEnvelope namespace.
 * 
 */
public class ERICEnvelopeFilter implements DocumentErrorFilter {

    public boolean collectError(final DocumentError e) {
        boolean result = true;

        final ElementReference elementRef = e.getElementReference();
        if (elementRef != null) {
            final String elementNamespace = elementRef.getNamespaceURL();
            if (ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE.equals(elementNamespace)) {
                result = false;
            }
        }

        return result;
    }
}
