package ericResponse.output;

import java.util.List;

import ericResponse.output.error.EricResponseError;

/**
 * This interface represents a filter that may be applied to the list of ERIC
 * errors that are mapped during the response stage.
 * <p>
 * Zero or more filters may be registered prior to the validator reaching the
 * response stage. At this point, each registered filter is applied in the order
 * it was registered. Each one gets the output of the previous filter. The final
 * filtered list is the one the client sees as part of the validator response.
 * 
 * @see EricResponseErrorMapper#addEricErrorFilter(EricErrorFilter)
 * @see EricResponsePostValidationDelegate#addErrorFilter(EricErrorFilter)
 * 
 * @author jesse
 */
public interface EricErrorFilter {

    /**
     * Takes the list of mapped ERIC errors and returns a filtered list.
     */
    List<EricResponseError> filterErrors(List<EricResponseError> ericErrors);
}
