package ericResponse.output;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

import org.jdom.Element;
import org.jdom.Namespace;

import ericResponse.output.error.EricResponseError;

public class EricErrorResponseGenerator implements ResponseElementGenerator {

    private static final Namespace NAMESPACE_ERROR_RESPONSE = Namespace.getNamespace("http://www.govtalk.gov.uk/CM/errorresponse");

    List<ApplicationElementGenerator> applicationElementGenerators = new ArrayList<ApplicationElementGenerator>();

    public List<Element> generateResponse(final List<Element> children, List<EricResponseError> ericErrors,
            final EricResponseParams params) {
        /*
         * If there are no errors then we've got nothing to do, so return null.
         */
        if (ericErrors.isEmpty()) {
            return null;
        }

        // sorting should be enabled for running regression tests, but not for
        // production
        if (params.isSortErrorsEnabled()) {
            ericErrors = sort(ericErrors);
        }

        final Element elErrorResponse = new Element("ErrorResponse", NAMESPACE_ERROR_RESPONSE);
        elErrorResponse.addNamespaceDeclaration(NAMESPACE_XSI);

        final EricErrorXMLImpl ericErrorXMLImpl = new EricErrorXMLImpl(NAMESPACE_ERROR_RESPONSE.getURI(), params,
                applicationElementGenerators);
        ericErrorXMLImpl.writeToElement(elErrorResponse, ericErrors);

        final List<Element> list = new ArrayList<Element>(1);
        list.add(elErrorResponse);
        return list;
    }

    private static final List<EricResponseError> sort(final List<EricResponseError> ericErrors) {
        final SortedMap<String, EricResponseError> sortedMap = new TreeMap<String, EricResponseError>();

        for (int i = 0; i < ericErrors.size(); i++) {
            final EricResponseError error = ericErrors.get(i);

            final String text = error.getMessageText();
            final String number = error.getCode();
            final String type = error.getErrorType().toString();
            final String location = error.getLocator();

            /*
             * Multiple errors with the exact same text, number, type and
             * location would overwrite in the Map so tack the loop counter on
             * to the end to form a unique key.
             */
            final String key = number + type + text + location + i;

            // add the element to sorted map
            sortedMap.put(key, error);
        }

        final List<EricResponseError> sortedList = new ArrayList<EricResponseError>();
        for (final EricResponseError error : sortedMap.values()) {
            sortedList.add(error);
        }

        return sortedList;
    }

    public void addApplicationElementGenerators(final List<ApplicationElementGenerator> appElementGenerators) {
        this.applicationElementGenerators.addAll(appElementGenerators);
    }
}
