/*
 * Created on Nov 10, 2005
 * 
 * $Id: EricErrorXMLImpl.java,v 1.17 2006/01/26 11:51:00 dec Exp $
 */
package ericResponse.output;

import java.util.List;

import org.jdom.Element;

import ericResponse.output.error.EricResponseError;

/**
 * */
public class EricErrorXMLImpl implements ErrorXML {

    private final String namespaceURL;

    /**
     * @directed
     */
    private final EricResponseParams params;

    private final List<ApplicationElementGenerator> applicationElementGenerators;

    public EricErrorXMLImpl(final String namespaceURL, final EricResponseParams params,
            final List<ApplicationElementGenerator> applicationElementGenerators) {
        this.namespaceURL = namespaceURL;
        this.params = params;
        this.applicationElementGenerators = applicationElementGenerators;
    }

    /**
     * writes the error group as xml to the element
     * 
     * @param element
     *            the element that is written to
     * @param ericResponseErrors
     *            the list contianing the errors
     */
    public void writeToElement(final Element element, final List<EricResponseError> ericResponseErrors) {
        final JDOMGeneratorList jdl = new JDOMGeneratorList(ericResponseErrors, namespaceURL, params);

        if (params.outputErrorCount()) {
            applicationElementGenerators.add(new MessageCountGenerator(jdl));
        }

        if (applicationElementGenerators.size() > 0) {
            final Element application = new Element("Application", namespaceURL);
            for (final ApplicationElementGenerator appGenerator : applicationElementGenerators) {
                application.addContent(appGenerator.generate(params));
            }
            element.addContent(application);
        }

        int maxErrorCount = jdl.size();
        if (params.getMaxErrorsToReport() > 0) {
            if (maxErrorCount > params.getMaxErrorsToReport()) {
                maxErrorCount = params.getMaxErrorsToReport();
            }
        }

        for (int i = 1; i < maxErrorCount; i++) {
            final Element e = jdl.get(i);
            element.addContent(e);
        }
    }
}
