/*
 * Created on 07-Dec-2005
 * 
 * $Id: EricResponseErrorMapper.java,v 1.12 2006/08/10 15:19:11 dec Exp $
 */
package ericResponse.output;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import processingError.ProcessingError;
import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorBean;
import ericResponse.output.error.EricResponseErrorFactory;
import ericResponse.output.translator.CompositeErrorTranslator;
import ericResponse.output.translator.EricErrorTranslator;
import ericResponse.output.translator.TranslationContext;
import ericResponse.output.translator.genericerror.GenericErrorMapper;
import ericResponse.output.translator.mapper.ErrorMapper;

/**
 * @author Douglas Clinton
 * @since 07-Dec-2005
 */
public class EricResponseErrorMapper {

    // private static final Logger logger =
    // LoggerFactory.getLogger("ericresponse.translation");

    private final CompositeErrorTranslator xlator;

    private final List<EricErrorFilter> errorFilters = new LinkedList<EricErrorFilter>();

    private final EricResponseErrorFactory ereFactory;

    public EricResponseErrorMapper(final EricResponseParams params, EricResponseErrorFactory ereFactory) {
        xlator = new CompositeErrorTranslator(params);

        if (ereFactory == null) {
            ereFactory = new EricResponseErrorFactory() {
                public EricResponseError createEricResponseError(final ERErrorDetail detail, final ProcessingError pe,
                        final TranslationContext context, final ErrorMapper mapper) {
                    return new EricResponseErrorBean(detail, pe, context, mapper);
                }
            };
        }
        this.ereFactory = ereFactory;
    }

    public void addErrorMapper(final ErrorMapper mapper) {
        xlator.addErrorMapper(mapper, ereFactory);
    }

    public void addErrorMappers(final String basePackageName) {
        xlator.addErrorMappers(basePackageName, ereFactory);
    }

    public void addGenericMapper(final GenericErrorMapper mapper) {
        xlator.addGenericMapper(mapper);
    }

    public void addGenericMappers(final String basePackageName) {
        xlator.addGenericMappers(basePackageName);
    }

    public void addEricErrorFilter(final EricErrorFilter filter) {
        errorFilters.add(filter);
    }

    /**
     * Translates a list of ProcessingErrors to a List of EricResponseErrors
     * 
     * @param errors
     *            the list of ProcessingErrors to be translated
     * @return a List of EricResponseErrors
     */
    public List<EricResponseError> mapProcessingErrors(final List<ProcessingError> errors, final TranslationContext context) {
        List<EricResponseError> result = new ArrayList<EricResponseError>(errors.size());

        for (final ProcessingError processingError : errors) {

            final EricResponseError ericResponseError = mapProcessingError(processingError, context);

            if (ericResponseError != null && ericResponseError != EricErrorTranslator.DO_NOT_MAP) {
                result.add(ericResponseError);
            }
        }

        // run error filters, if any
        for (final EricErrorFilter ericErrorFilter : errorFilters) {
            result = ericErrorFilter.filterErrors(result);
        }

        return result;
    }

    public EricResponseError mapProcessingError(final ProcessingError processingError, final TranslationContext context) {
        final EricResponseError ericResponseError = xlator.translateError(processingError, context);
        return ericResponseError;
    }

}
