package ericResponse.output;

import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;

import ericResponse.output.error.EricResponseError;

public class EricResponseGenerator {

    private final EricResponseParams responseParams;

    private LinkedList<ResponseElementGenerator> generators = null;

    public EricResponseGenerator(final EricResponseParams responseParams) {
        this.responseParams = responseParams;
    }

    public void addResponseGenerator(final ResponseElementGenerator generator) {
        if (generators == null) {
            generators = new LinkedList<ResponseElementGenerator>();
        }
        generators.addFirst(generator);
    }

    public void addResponseGenerators(final List<ResponseElementGenerator> generators) {
        for (final ResponseElementGenerator element : generators) {
            addResponseGenerator(element);
        }
    }

    public void generateResponse(final List<EricResponseError> ericErrors, final Writer output) {
        if (generators == null) {
            return;
        }

        final Document document = generateOutputDocument(ericErrors);
        JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());
    }

    private Document generateOutputDocument(final List<EricResponseError> ericErrors) {
        List<Element> lastChildren = null;
        for (final ResponseElementGenerator generator : generators) {
            final List<Element> children = generator.generateResponse(lastChildren, ericErrors, responseParams);
            if (children != null)
                lastChildren = children;
        }

        Element root = null;
        if (lastChildren != null && !lastChildren.isEmpty()) {
            if (lastChildren.size() == 1) {
                root = lastChildren.get(0);
            } else {
                // here we need to create a stand-in root element, this case
                // should never occur in a live environment, but can be useful
                // for testing
                root = new Element("ValidationResult");
                root.addContent(lastChildren);
            }
        }

        final Document document = new Document();
        if (root != null) {
            document.setRootElement(root);
        }
        return document;
    }
}
