/*
 * Created on 16-Dec-2005
 * 
 * $Id: EricResponseParams.java,v 1.8 2006/03/27 08:19:01 dec Exp $
 */
package ericResponse.output;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Douglas Clinton
 * @since 16-Dec-2005
 */
public class EricResponseParams {

    public static final int NO_ERROR_LIMIT = -1;

    // used to store additional, arbitrary name/object attribute pairings
    private Map<String, Object> attributes;

    private int maxErrorsToReport = NO_ERROR_LIMIT;

    private String failureMessage = "Your submission failed due to business validation errors. Please see below for details.";

    private String raisedBy = "IR-ERSS";

    private String govTalkRaisedBy = "Department";

    private boolean outputExtraDetails = true;

    private boolean outputQS3Discrepancy = false;

    private String namespaceURL;

    private boolean includeKeys = false;

    /**
     * sorting should be enabled for running regression tests, but not for
     * production
     */
    private boolean sortErrorsEnabled = false;

    // This is used to override the envelope version supplied in the submission
    private String overrideGatewayEnvelopeVersion = null;

    // Set this to force a message class. Otherwise the message class of the
    // incoming submission will be used.
    private String overrideMessageClass;

    // This flag determines the output of "GovTalkErrors" section in
    // GovTalkMessage
    private boolean areGovTalkErrorsRequired = true;

    /**
     * In some environments we want an element included in the response which
     * says how many errors are included. In others, we don't.
     */
    private boolean outputErrorCount = true;

    private boolean forceDynamicClassCollection = false;

    private boolean generateGovTalkEnvelope = true;

    @Override
    public String toString() {
        String s = "EricResponseParams [";
        s += "attributes=" + attributes;
        s += ", ";
        s += "maxErrorsToReport=" + maxErrorsToReport;
        s += ", ";
        s += "raisedBy=" + raisedBy;
        s += ", ";
        s += "govTalkRaisedBy=" + govTalkRaisedBy;
        s += ", ";
        s += "outputExtraDetails=" + outputExtraDetails;
        s += ", ";
        s += "includeKeys=" + includeKeys;
        s += ", ";
        s += "sortErrorsEnabled=" + sortErrorsEnabled;
        s += ", ";
        s += "overrideGatewayEnvelopeVersion=" + overrideGatewayEnvelopeVersion;
        s += ", ";
        s += "overrideMessageClass=" + overrideMessageClass;
        s += ", ";
        s += "areGovTalkErrorsRequired=" + areGovTalkErrorsRequired;
        s += ", ";
        s += "outputErrorCount=" + outputErrorCount;
        s += ", ";
        s += "forceDynamicClassCollection=" + forceDynamicClassCollection;
        s += ", ";
        s += "generateGovTalkEnvelope=" + generateGovTalkEnvelope;
        s += "]";

        return s;
    }

    public boolean areGovTalkErrorsRequired() {
        return areGovTalkErrorsRequired;
    }

    public void setAreGovTalkErrorsRequired(final boolean areGovTalkErrorsRequired) {
        this.areGovTalkErrorsRequired = areGovTalkErrorsRequired;
    }

    public int getMaxErrorsToReport() {
        return maxErrorsToReport;
    }

    public void setMaxErrorsToReport(final int errorLimit) {
        this.maxErrorsToReport = errorLimit;
    }

    public boolean getOutputExtraDetails() {
        return outputExtraDetails;
    }

    public void setOutputExtraDetails(final boolean outputExtraDetails) {
        this.outputExtraDetails = outputExtraDetails;
    }

    public String getFailureMessage() {
        return failureMessage;
    }

    public void setFailureMessage(final String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getRaisedBy() {
        return raisedBy;
    }

    public void setRaisedBy(final String raisedBy) {
        this.raisedBy = raisedBy;
    }

    public String getNamespaceURL() {
        return namespaceURL;
    }

    public void setNamespaceURL(final String namespaceURL) {
        this.namespaceURL = namespaceURL;
    }

    public boolean includeKeys() {
        return includeKeys;
    }

    public void setIncludeKeys(final boolean includeKeys) {
        this.includeKeys = includeKeys;
    }

    public void setOverrideGatewayEnvelopeVersion(final String overrideGatewayEnvelopeVersion) {
        if ("1.0".equals(overrideGatewayEnvelopeVersion) || "2.0".equals(overrideGatewayEnvelopeVersion)) {
            this.overrideGatewayEnvelopeVersion = overrideGatewayEnvelopeVersion;
        } else {
            throw new IllegalArgumentException("Only envelope versions of 1.0 or 2.0 are acceptable");
        }
    }

    public String getOverrideGatewayEnvelopeVersion() {
        return this.overrideGatewayEnvelopeVersion;
    }

    public String getOverrideMessageClass() {
        return overrideMessageClass;
    }

    public void setOverrideMessageClass(final String overrideMessageClass) {
        this.overrideMessageClass = overrideMessageClass;
    }

    public boolean isSortErrorsEnabled() {
        return sortErrorsEnabled;
    }

    public void setSortErrorsEnabled(final boolean sortErrorsEnabled) {
        this.sortErrorsEnabled = sortErrorsEnabled;
    }

    public String getGovTalkRaisedBy() {
        return govTalkRaisedBy;
    }

    public void setGovTalkRaisedBy(final String govTalkRaisedBy) {
        this.govTalkRaisedBy = govTalkRaisedBy;
    }

    public Object getAttribute(final String name) {
        if (attributes == null)
            return null;
        return attributes.get(name);
    }

    public void setAttribute(final String name, final Object value) {
        if (attributes == null)
            attributes = new HashMap<String, Object>();
        attributes.put(name, value);
    }

    public boolean outputErrorCount() {
        return outputErrorCount;
    }

    public void setOutputErrorCount(final boolean outputErrorCount) {
        this.outputErrorCount = outputErrorCount;
    }

    public boolean getForceDynamicClassCollection() {
        return forceDynamicClassCollection;
    }

    public void setForceDynamicClassCollection(final boolean forceDynamicClassCollection) {
        this.forceDynamicClassCollection = forceDynamicClassCollection;
    }

    public boolean getGenerateGovTalkEnvelope() {
        return generateGovTalkEnvelope;
    }

    public void setGenerateGovTalkEnvelope(final boolean generateGovTalkEnvelope) {
        this.generateGovTalkEnvelope = generateGovTalkEnvelope;
    }

    public void setOutputQS3Discrepancy(boolean outputQS3Discrepancy) {
        this.outputQS3Discrepancy = outputQS3Discrepancy;
    }

    public boolean getOutputQS3Discrepancy() {
        return outputQS3Discrepancy;
    }

}
