package ericResponse.output;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import ericResponse.output.error.EricResponseError;
import govtalk.header.GovTalkHeaderDetails;

public class GovTalkEnvelopeGenerator implements ResponseElementGenerator {

    private final GovTalkHeaderDetails govTalkHeaderDetails;

    public GovTalkEnvelopeGenerator(final GovTalkHeaderDetails govTalkHeaderDetails) {
        this.govTalkHeaderDetails = govTalkHeaderDetails;
    }

    public List<Element> generateResponse(final List<Element> children, final List<EricResponseError> ericErrors,
            final EricResponseParams params) {
        final GovTalkMessage govTalkMessage = GovTalkMessage.generate(govTalkHeaderDetails, ericErrors.size(), params);

        if (children != null) {
            govTalkMessage.getBodyElement().addContent(children);
        }

        final List<Element> list = new ArrayList<Element>(1);
        list.add(govTalkMessage.getRootElement());
        return list;
    }
}
