package ericResponse.output;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 * Utility class for creating IRmark receipt signature XML for including in HMRC
 * response.
 * 
 * @author jesse
 */
public final class IRmarkSignature {

    private static final Namespace NAMESPACE_DSIG = Namespace.getNamespace("dsig", "http://www.w3.org/2000/09/xmldsig#");

    private static final Namespace NAMESPACE_SARVEGA = Namespace.getNamespace("sarvega", "http://www.sarvega.com/xslt");

    public static final Element createSignature(final String digest) {
        final Element elSignature = new Element("Signature", NAMESPACE_DSIG);
        elSignature.addNamespaceDeclaration(NAMESPACE_DSIG);

        final Element elSignedInfo = new Element("SignedInfo", NAMESPACE_DSIG);
        elSignedInfo.addNamespaceDeclaration(NAMESPACE_SARVEGA);
        elSignature.addContent(elSignedInfo);

        final Element elCanonicalizationMethod = new Element("CanonicalizationMethod", NAMESPACE_DSIG);
        elCanonicalizationMethod.setAttribute(new Attribute("Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        elSignedInfo.addContent(elCanonicalizationMethod);

        final Element elSignatureMethod = new Element("SignatureMethod", NAMESPACE_DSIG);
        elSignatureMethod.setAttribute(new Attribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        elSignedInfo.addContent(elSignatureMethod);

        final Element elReference = new Element("Reference", NAMESPACE_DSIG);
        elSignedInfo.addContent(elReference);

        final Element elTransforms = new Element("Transforms", NAMESPACE_DSIG);
        elReference.addContent(elTransforms);

        Element elTransform;

        elTransform = new Element("Transform", NAMESPACE_DSIG);
        elTransform.setAttribute(new Attribute("Algorithm", "http://www.w3.org/TR/1999/REC-xpath-19991116"));
        elTransforms.addContent(elTransform);

        final Element elXPath = new Element("XPath", NAMESPACE_DSIG);
        elXPath.setText("(count(ancestor-or-self::node()|/gti:GovTalkMessage/gti:Body)=count(ancestor-or-self::node()))"
                + " and (count(ancestor-or-self::node()|/gti:GovTalkMessage/gti:Body/*[name()='IRenvelope']/*[name()="
                + "'IRheader']/*[name()='IRmark'])!=count(ancestor-or-self::node()))");
        elTransform.addContent(elXPath);

        elTransform = new Element("Transform", NAMESPACE_DSIG);
        elTransform.setAttribute(new Attribute("Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments"));
        elTransforms.addContent(elTransform);

        final Element elDigestMethod = new Element("DigestMethod", NAMESPACE_DSIG);
        elDigestMethod.setAttribute(new Attribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1"));
        elReference.addContent(elDigestMethod);

        final Element elDigestValue = new Element("DigestValue", NAMESPACE_DSIG);
        elDigestValue.setText(digest);
        elReference.addContent(elDigestValue);

        final Element elSignatureValue = new Element("SignatureValue", NAMESPACE_DSIG);
        elSignatureValue.setText("Ev0Yy9BPcmcy2HZdKFlemmUbGehfLuif2c1SCJjYp4hoNWBTl5qumkUpMidPJBoAvkVi1Dud/trP9EJjJpkjIs35z"
                + "z2Xumyc+eM+LPgLT6MCCoRWcUSF/HcCQ/ZnMrT8KxkVMZ5a3vKYW72Ik6q/Wby2coksa/GC5NF0ntbSozk=");
        elSignature.addContent(elSignatureValue);

        final Element elKeyInfo = new Element("KeyInfo", NAMESPACE_DSIG);
        elSignature.addContent(elKeyInfo);

        final Element elX509Data = new Element("X509Data", NAMESPACE_DSIG);
        elKeyInfo.addContent(elX509Data);

        final Element elX509Certificate = new Element("X509Certificate", NAMESPACE_DSIG);
        elX509Certificate.setText("MIIB2jCCAUOgAwIBAgIBADANBgkqhkiG9w0BAQQFADAzMQ0wCwYDVQQIEwRUZXN0MQ0wCwYDVQQKEwRUZXN0MRMw"
                + "EQYDVQQDEwpTZXJ2ZXJUZXN0MB4XDTA1MTAyNjE1NTA0M1oXDTA2MTAyNjE1NTA0M1owMzENMAsGA1UECBMEVGVzdDENMAsGA1UE"
                + "ChMEVGVzdDETMBEGA1UEAxMKU2VydmVyVGVzdDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAt6pTgZvduLXuHbMv3Gz55nFF"
                + "Q27Dq7nQmA9l/QFlqfFKz2NM6jFO4EY8xRY2DBeywtyrQEwzYGi3AAjoVHy6i1gDsc3LHQBoKocyX/uc37l90iqFe7Xki1AIAHk+"
                + "DhMEYCCFrhAI1xhZInCDacXzzOtJTWBaSztyhA7XMmHytj0CAwEAATANBgkqhkiG9w0BAQQFAAOBgQAjaJZQCMB/epLcS3NMDi7G"
                + "TJQHDfp6kdUF44VVM7ju0fk6l1on0Etkg4eoj81ORPXANePSN8dEI6TBuaZMTtYoIlEyOtMqLrGbdy4D7bJ47UtOWfFUqGriqU2F"
                + "fN4/BWOdCUaXIiixxV2stVIT3B2y17d5tAg7D71Zydk2WJ2tiA==");
        elX509Data.addContent(elX509Certificate);

        return elSignature;
    }
}
